<?php
/**
 * osCommerce Online Merchant
 * 
 * @copyright Copyright (c) 2011 osCommerce; http://www.oscommerce.com
 * @license BSD License; http://www.oscommerce.com/bsdlicense.txt
 */

  use osCommerce\OM\Core\HTML;
  use osCommerce\OM\Core\OSCOM;
?>

<h1><?php echo $OSCOM_Template->getIcon(32) . HTML::link(OSCOM::getLink(), $OSCOM_Template->getPageTitle()); ?></h1>

<?php
  if ( $OSCOM_MessageStack->exists() ) {
    echo $OSCOM_MessageStack->get();
  }
?>

<div class="infoBox">
  <h3><?php echo HTML::icon('new.png') . ' ' . OSCOM::getDef('action_heading_new_country'); ?></h3>

  <form name="cNew" class="dataForm" action="<?php echo OSCOM::getLink(null, null, 'Save&Process'); ?>" method="post">

  <p><?php echo OSCOM::getDef('introduction_new_country'); ?></p>

  <fieldset>
    <p><label for="countries_name"><?php echo OSCOM::getDef('field_name'); ?></label><?php echo HTML::inputField('countries_name'); ?></p>
    <p><label for="countries_iso_code_2"><?php echo OSCOM::getDef('field_iso_code_2'); ?></label><?php echo HTML::inputField('countries_iso_code_2'); ?></p>
    <p><label for="countries_iso_code_3"><?php echo OSCOM::getDef('field_iso_code_3'); ?></label><?php echo HTML::inputField('countries_iso_code_3'); ?></p>
    <p><label for="address_format"><?php echo OSCOM::getDef('field_address_format'); ?></label><?php echo HTML::textareaField('address_format'); ?><br /><i>:name</i>, <i>:street_address</i>, <i>:suburb</i>, <i>:city</i>, <i>:postcode</i>, <i>:state</i>, <i>:state_code</i>, <i>:country</i></p>
  </fieldset>

  <p><?php echo HTML::button(array('priority' => 'primary', 'icon' => 'check', 'title' => OSCOM::getDef('button_save'))) . ' ' . HTML::button(array('href' => OSCOM::getLink(), 'priority' => 'secondary', 'icon' => 'close', 'title' => OSCOM::getDef('button_cancel'))); ?></p>

  </form>
</div>
